/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TxtShow {
    String[] txtStrs;
    public int txtDrawX;
    public int txtDrawY;
    int txtWidth;
    int lineHeight;
    int lineShowNum;
    int txtPageNum;
    int txtShowPageID;
    int txtColor = 0xFFFFFF;
    Font txtFont;
    byte horizontalType;
    static final byte H_LEFT = 0;
    static final byte H_RIGHT = 1;
    static final byte H_CENTER = 3;
    int bgColor;
    int jumpRange;
    int countTimes;

    public TxtShow(String[] stringArray, int n, int n2, int n3, int n4, int n5, Font font) {
        this.init(n, n2, n3, n4, n5, font);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                vector.addElement(stringArray[i]);
                continue;
            }
            String[] stringArray2 = null;
            stringArray2 = Tool.getStrings(stringArray[i], n3, this.txtFont);
            for (int j = 0; j < stringArray2.length; ++j) {
                vector.addElement(stringArray2[j]);
            }
        }
        this.txtStrs = new String[vector.size()];
        vector.copyInto(this.txtStrs);
        this.initPageData();
    }

    public TxtShow(String string, int n, int n2, int n3, int n4, int n5, Font font) {
        this.init(n, n2, n3, n4, n5, font);
        this.txtStrs = Tool.getStrings(string, n3, this.txtFont);
        this.initPageData();
    }

    private void init(int n, int n2, int n3, int n4, int n5, Font font) {
        this.txtDrawX = n;
        this.txtDrawY = n2;
        this.txtWidth = n3;
        this.lineHeight = n4;
        this.lineShowNum = n5;
        this.txtFont = font;
    }

    public void initPageData() {
        this.txtPageNum = this.txtStrs.length / this.lineShowNum;
        if (this.txtStrs.length % this.lineShowNum != 0) {
            ++this.txtPageNum;
        }
        this.txtShowPageID = 0;
    }

    public void setTxtMode(byte by, int n, int n2, int n3) {
        this.horizontalType = by;
        this.txtColor = n;
        this.bgColor = n2;
        this.jumpRange = n3;
    }

    public boolean keyPressed(int n) {
        switch (n) {
            case 1: {
                if (this.txtShowPageID <= 0) break;
                --this.txtShowPageID;
                break;
            }
            case 2: {
                if (this.txtShowPageID < this.txtPageNum - 1) {
                    ++this.txtShowPageID;
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public boolean pageDown() {
        if (this.txtShowPageID < this.txtPageNum - 1) {
            ++this.txtShowPageID;
        } else {
            return true;
        }
        return false;
    }

    public boolean pageUp() {
        if (this.txtShowPageID > 0) {
            --this.txtShowPageID;
        }
        return false;
    }

    public boolean updateDialog() {
        return ++this.txtShowPageID >= this.txtPageNum;
    }

    public void draw(Graphics graphics) {
        ++this.countTimes;
        if (this.txtStrs == null) {
            return;
        }
        graphics.setFont(this.txtFont);
        for (int i = 0; i < this.lineShowNum; ++i) {
            int n;
            int n2 = this.lineShowNum * this.txtShowPageID + i;
            if (n2 >= this.txtStrs.length) continue;
            switch (this.horizontalType) {
                case 3: {
                    n = this.txtDrawX + (this.txtWidth - Tool.font.stringWidth(this.txtStrs[n2]) >> 1);
                    break;
                }
                case 1: {
                    n = this.txtDrawX + this.txtWidth - Tool.font.stringWidth(this.txtStrs[n2]);
                    break;
                }
                default: {
                    n = this.txtDrawX;
                }
            }
            Tool.drawString(graphics, this.txtStrs[n2], n, this.txtDrawY + this.lineHeight * i, this.txtColor, this.bgColor, this.jumpRange);
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        ++this.countTimes;
        if (this.txtStrs == null) {
            return;
        }
        graphics.setFont(this.txtFont);
        for (int i = 0; i < this.lineShowNum; ++i) {
            int n3;
            int n4 = this.lineShowNum * this.txtShowPageID + i;
            if (n4 >= this.txtStrs.length) continue;
            switch (this.horizontalType) {
                case 3: {
                    n3 = n + (this.txtWidth - Tool.font.stringWidth(this.txtStrs[n4]) >> 1);
                    break;
                }
                case 1: {
                    n3 = n + this.txtWidth - Tool.font.stringWidth(this.txtStrs[n4]);
                    break;
                }
                default: {
                    n3 = n;
                }
            }
            Tool.drawString(graphics, this.txtStrs[n4], n3, n2 + this.lineHeight * i, this.txtColor, this.bgColor, this.jumpRange);
        }
    }
}

